	function [Residues, P, Mult] = PART_FRACT_EXPANSION(G, Z, P)
 
	% 	Performs Partial Fraction Expansion of a rational function with
	%	
	%	order(denominator) > order(numerator)
	%
	%	described by the poles and zeros.  
	%	If not, see PZ_2_IMPULSE_RESPONSE_S or PZ_2_IMPULSE_RESPONSE_Z.
	%	Multiple poles are acceptable, but we assume that the coefficients in 
	%	the numerator polynomial are real.
 
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar 1983-03-19
	% 	Modified by: 	LW, 2005-12-28, 2006-08-27, 2010-08-06
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1
	% 	Known bugs:	 
	% 	Report bugs to:	Wanhammar@gmail.com
 
	% 	Reference:		F.Y. Chin and K. Steiglitz, An O(N^2) Algorithm for 
	%					Partial Fraction Expansion, IEEE Trans. on Circuits and 
	%					Systems, pp. 4245, Jan. 1977
	
	tol = 100*eps;					% May be adjusted

	% Check of the orders are correct
	if length(P) <= length(Z)
		disp('Error, the numerator has equal or higher order then the denominator')
		disp('See PZ_2_IMPULSE_RESPONSE_S or PZ_2_IMPULSE_RESPONSE_Z for workaround')
		return
	end

	% Compute the numerator as a polynomial, which is bad from an accuracy point of view
	% We assume real coefficients in the numerator polynomial. The real operator can be removed if needed.	
	A = G*real(poly(Z));
	B = real(poly(P));
	while length(A)+1 < length(B)
		A = [0, A];
	end
 
	%	Sort the poles with increasing magnitudes in order not to destroy the accuracy.
	[dummy, index] = sort(abs(P));
	P = P(index);
	N = length(P);
	Flag = 1;
	while (Flag == 1)	%	Place multiple poles adjacent in the vector P
		Flag = 0;
		for  k = 1:N-1
			if (abs(P(k+1)) - abs(P(k)) <= tol) & (P(k+1)*P(k) < 0)
				if (P(k+1) > 0)
					Temp = P(k);
					P(k) = P(k+1);
					P(k+1) = Temp;
					Flag = 1;
				end
			end
		end
	end
	Mult = ones(1,N);	% Determine the multiplicity of the poles
	for  k = 1:N
		for n = N:-1:k+1
			if abs(P(k) - P(n)) <= tol
				Mult(k) = Mult(k)+1;
			end
		end
	end

	% Start of main routine
	for k = 1:N		% Start the loop that performs the expansion
		i1 = N-k+1;
		if (i1 ~= 1)  
			for m = 2:i1
				A(m) = A(m) + P(k)*A(m-1);	% Loop for polynomial division
			end
		end 

		for m = 1:k  			
			if (m == 1) 
				if (abs(P(1) - P(k)) <= tol)  break; end	
				Y = P(1) - P(k);
				A(N) = A(N)/Y;
			else	
				j1 = N-m+1;	
				if (abs(P(m) - P(m-1)) <= tol) 
					A(j1) = (A(j1) - A(j1+1))/Y;
				else
					A(i1) = A(i1) - A(j1+1);				
					if (abs(P(m) - P(k)) <= tol) break;	end				
					Y = P(m) - P(k);
					A(j1) = A(j1)/Y;
				end
			end     	
		end
	end
	Residues = fliplr(A);
